import axios from 'axios';

export const BaseUrl = 'http://demo.trusty-pay.com';

axios.defaults.baseURL = BaseUrl;
axios.defaults.headers.post['Content-Type'] = 'application/json';
axios.defaults.validateStatus = () => true;
type CommonResponse<T> = {
  data: T;
  code: number;
  msg: string;
};

export type CreateOrderResult = {
  appUrl: string;
  id: number;
};

export enum OrderStatus {
  // 01 processing 02 success 03 fail 04 refund
  Processing = '01',
  Success = '02',
  Fail = '03',
  Refund = '04',
}
export type OrderDetailResult = {
  id: number;
  desc: string;
  amount: number;
  tradeNo: string;
  status: OrderStatus;
  createTime: string;
  updateTime: string;
};

export function createOrder(data: {amount: number; name: string}) {
  return axios.post<CommonResponse<CreateOrderResult>>('/order/pay', {
    productName: data.name,
    amount: data.amount,
  });
}

export function queryOrder(id: number) {
  return axios.post<CommonResponse<OrderDetailResult>>('/order/get/' + id);
}
